---
title: "Specify comparison of interest and statistical method"
author: "AHMED hEMEDAN"
date: "09/01/2021"
---
library(pacman)
library(devtools)
library(miRNetR)

pacman::p_load(RSQLite, Cairo, fastmatch, igraph, RJSONIO, foreach, doParallel, preprocessCore, limma, edgeR, HTqPCR, genefilter)

#Initiate the dataSet object
Init.Data("mir", "mirlist")
#### Step 2. Set up the user input data
SetupMirListData(mirs = "hsa-mir-101-3p", orgType = "hsa", idType = "mir_id", tissue = "Brain")
##Set up targets
nms.vec = c("gene") 
SetCurrentDataMulti()
#Perform miRNAs to target genes mapping, 
QueryMultiListMir()
head(dataSet$mir.res, n = 3L)
#Generate miRNA-gene network files
CreateMirNets(net.type = "mir2gene")
#Prepare network files, 
#### results are downloaded in your working directory ("node_table_mirnet_0.csv", "mirnet_0.json" and "mirnet.graphml")
PrepareMirNet(mir.nm = "mirnet1", file.nm = "mirnet_0.json")
#### Step 7. Perform miRNA family enrichment analysis, 
#### results are downloaded in your working directory ("network_enrichment_mirfamily_1.json" and "mirnet_enrichment.csv")
PerformMirTargetEnrichAnalysis(
  adjust.type = "NA",
  fun.type = "mirfamily",
  file.nm = "network_enrichment_mirfamily_1",
  IDs = "hsa-mir-101-3p; hsa-mir-147a; hsa-mir-361-5p; hsa-mir-133b; hsa-mir-510-5p; hsa-mir-3140-3p",
  algo = "hyp"
)

#Perform miRNA function enrichment analysis, 
PerformMirTargetEnrichAnalysis(
  adjust.type = "NA",
  fun.type = "func",
  file.nm = "network_enrichment_func_1",
  IDs = "hsa-mir-16-5p; hsa-mir-424-5p; hsa-mir-29c-3p; hsa-mir-29b-3p; hsa-mir-29a-3p; hsa-mir-148b-3p; hsa-mir-152-3p; hsa-mir-148a-3p; hsa-mir-335-5p",
  algo = "hyp"
)

resTable <- read.csv("mirnet_enrichment.csv", header=T, as.is=T)
head(resTable, n = 3L)

#Indicate target type
nms.vec = c("gene") 
SetCurrentDataMulti()


# Specify comparison of interest and statistical method

#Standard t-test
PerformHTqPCR("Ctrl vs. GrpA", "ttest")

# Feature selection

#Both direction
GetSigGenes(p.lvl = 0.2, fc.lvl = 0.0, direction = "both")
